/*
 * Himax_platform.h
 *
 *      Author: 903621
 */

#ifndef HIMAX_PLATFORM_H_
#define HIMAX_PLATFORM_H_

#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#ifndef UNITTEST
#include <hw/i2c.h>
#include <ctype.h>
#include <pthread.h>
#include <devctl.h>
#include <sys/select.h>
#include <sys/slog2.h>
#include <sys/mman.h>
#include <sys/neutrino.h>
#include "input/mtouch_driver.h"
#include "input/parseopts.h"
#include "input/inputtrace.h"
#include "input/mtouch_log.h"
#include "input/mtouch_params.h"
#else
#include "touchscreen_header.h"
#include "interrupt_header.h"
#endif
#include <fcntl.h>
#include "himax_touch_driver.h"

int himax_i2c_write(int fd, uint8_t addr, uint8_t *w_data, int w_len);
int himax_i2c_combined_writeread(int fd, uint8_t addr, uint8_t *r_data, int r_len);
int himax_register_read(int fd, uint8_t *read_addr, int read_len, uint8_t *read_data);
int himax_register_write(int fd, uint8_t *write_addr, uint8_t *write_data);

#endif /* HIMAX_PLATFORM_H_ */
